/****** Object:  StoredProcedure [dbo].[usp_Insert_Movement_Event]    Script Date: 03/22/2012 11:04:49 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Insert_Movement_Event]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Insert_Movement_Event]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		PII
-- Create date: 24.10.2012
-- Description:	Inserts a movement event.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Insert_Movement_Event] 
	@ID	INT OUTPUT,	
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@ENTERED_DATE DATETIME,
	@WARD_UID UNIQUEIDENTIFIER,
	@BED_UID UNIQUEIDENTIFIER,
	@OLD_WARD_UID UNIQUEIDENTIFIER,
	@OLD_BED_UID UNIQUEIDENTIFIER,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@TYPE_OF_MOVEMENT_CODE VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM VARCHAR(100),
	@TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME VARCHAR(100),
	@TYPE_OF_MOVEMENT_DISPLAY_NAME VARCHAR(250),
	@MOVEMENT_DATE DATETIME,
	@ENTERED_BY_UID	UNIQUEIDENTIFIER,
	@ADMISSION_IEN NVARCHAR(20)
AS
SET NOCOUNT ON

BEGIN
	
	IF EXISTS (SELECT ID FROM MOVEMENT_EVN WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID)		
		SELECT @ID = ID FROM MOVEMENT_EVN WHERE IEN = @IEN AND VISTA_SITE_UID = @VISTA_SITE_UID
	ELSE
		BEGIN
			DECLARE @TYPE_OF_MOVEMENT_ID INT, @ADMISSION_ID INT, @tmpID INT
			SELECT @ADMISSION_ID = ID FROM ADMISSION_EVN WHERE IEN = @ADMISSION_IEN AND VISTA_SITE_UID = @VISTA_SITE_UID
			
			-- TYPE OF MOVEMENT CONCEPT EXISTENCE CHECK
			EXEC dbo.usp_Manage_Concept 
				@CODE = @TYPE_OF_MOVEMENT_CODE, 
				@CODE_SYSTEM = @TYPE_OF_MOVEMENT_CODE_SYSTEM, 
				@CODE_SYSTEM_NAME = @TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, 
				@DISPLAY_NAME = @TYPE_OF_MOVEMENT_DISPLAY_NAME, 
				@ID = @TYPE_OF_MOVEMENT_ID OUTPUT

			SELECT TOP 1 @tmpID = ID FROM MOVEMENT_EVN WHERE VISTA_SITE_UID = @VISTA_SITE_UID AND MOVEMENT_DATE > @MOVEMENT_DATE AND ADMISSION_ID = @ADMISSION_ID ORDER BY MOVEMENT_DATE
			IF (@tmpID IS NOT NULL)
				BEGIN
					SELECT @OLD_BED_UID = OLD_BED_UID, @OLD_WARD_UID = OLD_WARD_UID FROM MOVEMENT_EVN WHERE ID = @tmpID
					UPDATE MOVEMENT_EVN
						SET OLD_BED_UID = @BED_UID,
							OLD_WARD_UID = @WARD_UID 
						WHERE ID = @tmpID
				END
			ELSE IF ((SELECT HAS_DISCHARGE FROM ADMISSION_EVN WHERE ID = @ADMISSION_ID) = 1)
				BEGIN
					SELECT @tmpID = ID FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ADMISSION_ID
					UPDATE DISCHARGE_EVN 
						SET BED_UID = @BED_UID,
							WARD_UID = @WARD_UID 
						WHERE ID = @tmpID
					UPDATE ADMISSION_EVN
						SET BED_UID = @BED_UID,
							WARD_UID = @WARD_UID 
						WHERE ID = @ADMISSION_ID
				END	
			
			INSERT INTO MOVEMENT_EVN
			(
				DOMAIN_ID,
				IEN,
				PATIENT_UID,
				ENTERED_DATE,
				WARD_UID, 
				BED_UID,
				OLD_WARD_UID,
				OLD_BED_UID,
				VISTA_SITE_UID,
				TYPE_OF_MOVEMENT_ID, 
				MOVEMENT_DATE,
				ENTERED_BY_UID,
				ADMISSION_ID
			)	
			VALUES	
			(
				@DOMAIN_ID,
				@IEN,
				@PATIENT_UID,
				@ENTERED_DATE,
				@WARD_UID, 
				@BED_UID,
				@OLD_WARD_UID,
				@OLD_BED_UID,
				@VISTA_SITE_UID,
				@TYPE_OF_MOVEMENT_ID, 
				@MOVEMENT_DATE, 
				@ENTERED_BY_UID,
				@ADMISSION_ID
			)
			
			SET @ID = IDENT_CURRENT('dbo.MOVEMENT_EVN')		
			
			IF (@ADMISSION_ID IS NOT NULL AND @tmpID IS NULL)
				BEGIN
					UPDATE ADMISSION_EVN
						SET BED_UID = @BED_UID,
							WARD_UID = @WARD_UID 
						WHERE ID = @ADMISSION_ID				
				END

			IF (@tmpID IS NOT NULL)
				SET @ID = -2
		END
END
GO
